/****** Object:  StoredProcedure [dbo].[P_RC_DEB_HISTORICO_RC_VD_CONV]    Script Date: 03/26/2014 10:46:14 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_RC_DEB_HISTORICO_RC_VD_CONV]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_RC_DEB_HISTORICO_RC_VD_CONV]
GO
GO
-- exec P_RC_DEB_HISTORICO_RC_VD_CONV 1,'2014-05-21'
CREATE PROCEDURE [dbo].[P_RC_DEB_HISTORICO_RC_VD_CONV] @CD_EMP INT=1, @DT_PROC DATETIME=NULL WITH ENCRYPTION AS 
SET NOCOUNT ON
DECLARE @CD_CTR INT
DECLARE @DT_ATUAL DATETIME 
SET @DT_ATUAL=GETDATE()

IF @DT_PROC IS NULL 
begin
	SET @DT_PROC = CONVERT(CHAR(10),GETDATE(),112)
end

CREATE TABLE #RsConvenioVenda (CD_EMP INT, CD_CTR INT,VLR_CONV MONEY)
CREATE TABLE #RsConvenioFechamento (CD_EMP INT, CD_CTR INT, VLR_CONV_FECHA MONEY)
CREATE TABLE #RsConvenioCreditos (CD_EMP INT, CD_CTR INT, VLR_CONV_CREDITO MONEY)
CREATE TABLE #RsConvenioDevolvido (CD_EMP INT, CD_CTR INT)

--Fechamento de convenio
insert into #RsConvenioFechamento
SELECT
	RC_VD_CONV_RC_DEB.CD_EMP,
	RC_VD_CONV_RC_DEB.CD_CTR,
	RC_VD_CONV_RC_DEB.VLR_VD_CONV
FROM
	RC_VD_CONV_RC_DEB INNER JOIN RC_DEB ON
	RC_VD_CONV_RC_DEB.CD_EMP = RC_DEB.CD_EMP AND
	RC_VD_CONV_RC_DEB.CD_FILIAL = RC_DEB.CD_FILIAL AND
	RC_VD_CONV_RC_DEB.CD_RC_DEB = RC_DEB.CD_RC_DEB
WHERE
	RC_DEB.DT_DP <= @DT_PROC

--Credito no vendas de convenio
insert into #RsConvenioCreditos (
CD_EMP, 
CD_CTR, 
VLR_CONV_CREDITO)
SELECT
	CD_EMP,
	CD_CTR,
	SUM(VLR_CRED)
FROM
	RC_VD_CONV_CRED
WHERE
	DT_CRED <=@DT_PROC
GROUP BY
	CD_EMP,
	CD_CTR

--Convenio devolvidos
INSERT INTO #RsConvenioDevolvido
SELECT
	RC_VD_CONV.CD_EMP,
	RC_VD_CONV.CD_CTR
FROM
	RC_VD_CONV INNER JOIN PDV_VD_RC_VD_CONV ON
	RC_VD_CONV.CD_EMP = PDV_VD_RC_VD_CONV.CD_EMP AND
	RC_VD_CONV.CD_CTR = PDV_VD_RC_VD_CONV.CD_CTR 
	INNER JOIN PDV_VD_CANCEL_CONV ON
	PDV_VD_RC_VD_CONV.CD_EMP =PDV_VD_CANCEL_CONV.CD_EMP AND
	PDV_VD_RC_VD_CONV.CD_FILIAL = PDV_VD_CANCEL_CONV.CD_FILIAL AND
	PDV_VD_RC_VD_CONV.CD_VD = PDV_VD_CANCEL_CONV.CD_VD
WHERE
	PDV_VD_CANCEL_CONV.DT_CAD <=@DT_PROC

--Vendas de convenio
INSERT INTO #RsConvenioVenda
select
	v.CD_EMP,
	v.CD_CTR,
	v.VLR_CONV
from
	RC_VD_CONV v LEFT OUTER JOIN #RsConvenioFechamento F ON
	v.CD_EMP = F.CD_EMP AND
	v.CD_CTR = F.CD_CTR 
	LEFT OUTER JOIN #RsConvenioCreditos c on
	v.CD_EMP = c.CD_EMP AND
	v.CD_CTR = c.CD_CTR 
	LEFT OUTER JOIN #RsConvenioDevolvido d on
	v.CD_EMP = d.CD_EMP AND
	v.CD_CTR = d.CD_CTR 
WHERE
	v.DT_VD <=@DT_PROC
	AND f.CD_CTR IS NULL
	AND c.CD_CTR IS NULL
	AND d.CD_CTR IS NULL

SET @CD_CTR=ISNULL((SELECT 
	MAX(CD_CTR)
FROM
	RC_DEB_HISTORICO
WHERE
	DT_PROC=@DT_PROC),0)

IF @CD_CTR > 0
begin
	DELETE 
		FROM RC_DEB_HISTORICO_CPL_RC_VD_CONV
	WHERE
		CD_CTR=@CD_CTR

	PRINT 'Lote atual.: ' + CONVERT(VARCHAR, @CD_CTR) + ' Parcelas convenio em aberto ' + convert(varchar,getdate(),108)
end

IF @CD_CTR=0
begin
	INSERT INTO RC_DEB_HISTORICO (DT_PROC,DT_CAD)
	SELECT
		@DT_PROC,
		@DT_ATUAL

	SET @CD_CTR = IDENT_CURRENT( 'RC_DEB_HISTORICO' )
	PRINT 'Lote novo.: ' + CONVERT(VARCHAR, @CD_CTR) + ' Parcelas convenio em aberto ' + convert(varchar,getdate(),108)
end

--Alterando valor em baixa parcial
update
	V
set
	v.VLR_CONV=(v.VLR_CONV-c.VLR_CONV_CREDITO)
FROM
	#RsConvenioVenda V INNER JOIN #RsConvenioCreditos c ON
	V.CD_EMP = c.CD_EMP AND
	V.CD_CTR = c.CD_CTR

--Deletando vendas sem saldo
delete
	v
from
	#RsConvenioVenda V
where
	v.VLR_CONV<=0

--Deletando quem tem fechamento de vendas
DELETE
	V
FROM
#RsConvenioVenda V INNER JOIN #RsConvenioFechamento F ON
V.CD_EMP = F.CD_EMP AND
V.CD_CTR = F.CD_CTR

--Deletando quem tem devolucao
DELETE
	V
FROM
	#RsConvenioVenda V INNER JOIN #RsConvenioDevolvido d ON
	V.CD_EMP = d.CD_EMP AND
	V.CD_CTR = d.CD_CTR

--Inserindo resultado 
INSERT INTO RC_DEB_HISTORICO_CPL_RC_VD_CONV (
	CD_CTR,
	CD_EMP,
	CD_CTR_CONV,
	VLR_CONV_SLD)
SELECT
	@CD_CTR,
	CD_EMP,
	CD_CTR,
	VLR_CONV
FROM
	#RsConvenioVenda


drop table #RsConvenioVenda;
drop table #RsConvenioFechamento;
drop table #RsConvenioCreditos;
drop table #RsConvenioDevolvido; 

